<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    include('core_production_preparation.php');  
class Production_Preparation extends Core_Production_Preparation
{
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
    }
     function createStoreNote(){
        $data=array();
        $this->load->model('Warehouse_Model');
        $this->load->model('Production_Estimate_Model');
        $data['main_menu_name'] = 'management';
        $data['sub_menu_name']  = 'create_store_note';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['department_list'] = $this->Warehouse_Model->getDepartment();
        $data['time_profile_list'] = $this->Production_Estimate_Model->loadTimeProfile(125567);
        $this->load->view('estimate/prepare_store_note_master',$data);
    }
     function saveStoreNote(){
        $this->load->library('form_validation');
		$this->form_validation->set_rules('warehouse_id', 'Warehouse', 'required|xss_clean');
		$this->form_validation->set_rules('department_id', 'Department', 'required|xss_clean');
		$this->form_validation->set_rules('datetime', 'Date', 'required|xss_clean');
		$this->form_validation->set_rules('time_profile_id', 'Time Profile', 'required|xss_clean');
		$this->form_validation->set_rules('ref_no', 'Ref No ', 'xss_clean');
	    $this->form_validation->set_rules('note', 'Note', 'xss_clean');
		$ref_no=$this->cleanAndValidateText($this->input->post('ref_no'));
		$warehouse_id=$this->cleanAndValidateNumber($this->input->post('warehouse_id'));
		$time_profile_id=$this->cleanAndValidateNumber($this->input->post('time_profile_id'));
		$department_id=$this->cleanAndValidateNumber($this->input->post('department_id'));
		$datetime=$this->cleanAndValidateNumber($this->input->post('datetime'));
	    $note=$this->cleanAndValidateText($this->input->post('note'));
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'psnm_manual_ref_no'=>$ref_no,
			'psnm_warehouse_id'=>$warehouse_id,
			'psnm_user_id'=>$this->session->userdata('ss_user_id'),
			'psnm_date_time'=>date('Y-m-d H:i:s'),
			'psnm_ref_no'=>$this->Common_Model->gen_ref_number('psnm_id','production_store_note_master','STN'),
			'shedule_date_time'=>date('Y-m-d H:i:s', strtotime($datetime)),
			'time_profile_id'=>$time_profile_id,
			'department_id'=>$department_id
		);
		$last_id= $this->executeSaveMasterTable($data);
		$st = array('status' =>1,'validation' =>'Added','result'=>$last_id);
        echo json_encode($st);
		}
    }
    function loadStoreNoteItems(){
        $id=$this->getId();
        $data=array();
        $data['details'] = $this->Production_Preparation_Model->getAllDetails($id);
        $data['main_menu_name'] = 'management';
        $data['sub_menu_name']  = 'not_complete_store_note';
        $data['stn_id'] =$id;
        $this->load->view('estimate/prepare_store_note_items',$data);
    }
     function getListPendingBatch(){
        $request_data=$this->getClientSideBasicDataTableParameters();
        $result_array=$this->getPendingBatchListForBasicDataTable($request_data);
        $values=$result_array['values'];
        $value_count=$result_array['value_count'];
        $totalData     = $value_count;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $row) {
	        $nestad_data=array();
	        $nestad_data[]  = $row['pbi_ref_no'];
	        $nestad_data[]  = $row['mtp_name'];
	        
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	        $nestad_data[]  = $row['mpt_name'];
	        $nestad_data[]  = $row['unit_name'];
	        $nestad_data[]  = $row['pbi_qty'];   
	        $action='<input type="checkbox" id="pbi_id'.$row['pbi_id'].'" name="pbi_id[]" value="'.$row['pbi_id'].'">';
	      $nestad_data[]  =$action;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        }else{
            $output = array(
                'data' => array(),
                "recordsTotal" => intval(0),
                "recordsFiltered" => intval(0)
            );
            echo json_encode($output);
        }
   }
    
    function saveStoreItems(){
        $this->load->library('form_validation');
		$this->form_validation->set_rules('warehouse_id', 'Warehouse', 'required|xss_clean');
		$this->form_validation->set_rules('master_id', 'Main Recode', 'required|xss_clean');
	    $this->form_validation->set_rules('pbi_id', 'Select Item', 'required');
		$master_id=$this->cleanAndValidateNumber($this->input->post('master_id'));
		$warehouse_id=$this->cleanAndValidateNumber($this->input->post('warehouse_id'));
	    $pbi_id=$this->cleanAndValidateArray($this->input->post('pbi_id'));
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
        foreach($pbi_id as $row){
	         $data=array(
			'psnm_id'=>$master_id,
			'pbi_id'=>$row,
		);
		$last_id= $this->executeSaveItemTable($data);
		$material_item_list=  $this->Production_Preparation_Model->runGetBatchSubItem($row);
		foreach($material_item_list as $mil){
             $data=array(
			'psnm_id'=>$master_id,
			'psni_id'=>$last_id,
			'pbi_id'=>$mil['pbi_id'],
			'pbsi_id'=>$mil['pbsi_id'],
		);
		$this->Production_Preparation_Model->runSaveSTNSubItems($data);
		}
		 $data=array(
			'pbi_pickup_status'=>1,
			'pbi_pickup_by'=>$this->session->userdata('ss_user_id'),
			'pbi_pickup_on'=>date('Y-m-d H:i:s'),
		);
		$this->executeUpdateSubItemTable($row,$data);
	    }
		$st = array('status' =>1,'validation' =>'Added','result'=>$last_id);
        echo json_encode($st);
		}
    }
    
    function getListSelectedBatch(){
        $request_data=$this->getClientSideBasicDataTableParameters();
        $result_array=$this->getSelectedBatchListForBasicDataTable($request_data);
        $values=$result_array['values'];
        $value_count=$result_array['value_count'];
        $totalData     = $value_count;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $row) {
	        $nestad_data=array();
	        $nestad_data[]  = $row['pbi_ref_no'];
	        $nestad_data[]  = $row['product_code'];
	        $nestad_data[]  = $row['product_name'];
	        $nestad_data[]  = $row['mpt_name'];
	        $nestad_data[]  = $row['unit_name'];
	        $nestad_data[]  = $row['pbi_qty'];   
	        $action='<button class="btn btn-xs btn-danger" id="delete'.$row['psni_id'].'" name="delete'.$row['psni_id'].'" onclick="rollback('.$row['psni_id'].')" >Rolll Back</button>';
	        if($row['psnm_status']==1){
	             $action='<span class="btn btn-xs btn-success" >Finished</span>';
	        }
	      $nestad_data[]  =$action;
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        }else{
            $output = array(
                'data' => array(),
                "recordsTotal" => intval(0),
                "recordsFiltered" => intval(0)
            );
            echo json_encode($output);
        }
   }
    function rollbackBatchToPendingStatus(){
        $id=$this->getId();
        $result=$this->executeSelectItemTable($id);
        if(isset($result['pbi_id'])){
           $main_recode_id=$result['pbi_id']; 
           $data=array(
            'pbi_rollback_status'=>1,
			'pbi_pickup_status'=>0,
			'pbi_rollback_by'=>$this->session->userdata('ss_user_id'),
			'pbi_rollback_on'=>date('Y-m-d H:i:s'),
		);
		$status=$this->executeUpdateSubItemTable($main_recode_id,$data);
		if($status==1){
		  $status=$this->executeDeleteItemTable($id);  
		  $status=$this->Production_Preparation_Model->runDeleteSTNSubItemUsingSecondryId($id);
		  
		}
		$st = array('status' =>$status,'validation' =>'Rollbacked','result'=>'null');
            echo json_encode($st);
        }else{
            $st = array('status' =>0,'validation' =>'Not Found','result'=>'null');
            echo json_encode($st);
        }
    }
    
     function notCompleteStoreNote(){
        $data=array();
        $this->load->model('Warehouse_Model');
        $data['main_menu_name'] = 'management';
        $data['sub_menu_name']  = 'not_complete_store_note';
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['department_list'] = $this->Warehouse_Model->getDepartment();
        $this->load->view('estimate/not_completed_store_note',$data);
    }
    
    function getListNotCompleteStoreNote(){
        $request_data=$this->getClientSideDataTableParameters();
        $result_array=$this->getNotCompleteStoreNoteForBasicDataTableOnServerSide($request_data);
        $values=$result_array['values'];
        $value_count=$result_array['value_count'];
        $totalData     = $value_count;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $row[]               = $products->psnm_ref_no;
                $row[]               = $products->psnm_manual_ref_no;
                $row[]               = $products->psnm_date_time;
                $row[]               = $products->user_first_name;
                $row[]               = $products->warehouse_name;
                $row[]               = $products->shedule_date_time;
                $row[]               = $products->m_department_name;
                
                if($products->time_profile_id==1){
                    $row[]               ="DAY";
                }else{
                    $row[]               ="NIGHT";
                    }
                $row[]               = $products->psnm_note;
                $actdes = '';
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                              <!--<li><a href="'.base_url('production_preparation/loadStoreNoteItems?id='. $products->psnm_id ).'"  style="cursor: pointer;"><i class="glyphicon fa fa-edit"></i> Update Store Note</a></li>-->
                                 <!--<li><a target="_blank" href="'.base_url('production_material_in_out/printSTN?id='. $products->psnm_id ).'"  style="cursor: pointer;"><i class="glyphicon fa fa-edit"></i> Print Store Note</a></li>-->
                           <li><a onclick="print_storenote('.$products->psnm_id.')" href="#"  style="cursor: pointer;"><i class="glyphicon fa fa-print"></i> Print BOM</a></li>
                           <li><a onclick="sent_stn_to_store('.$products->psnm_id.')" href="#"  style="cursor: pointer;"><i class="glyphicon fa fa-send-o"></i> Send To Stores</a></li> 
                            
                            ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
   }
    
    
    
    
    
   function getListSelectedBatchTotalMaterial(){
       $this->load->model('Stock_Counter_Model');
       ini_set('display_errors', 1); 
        $request_data=$this->getClientSideBasicDataTableParameters();
        $result_array=$this->getSelectedBatchMaterialListForBasicDataTable($request_data);
        $values=$result_array['values'];
        $value_count=$result_array['value_count'];
        $totalData     = $value_count;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $row) {
            $required_qty=  $this->Production_Preparation_Model->runGetSumAllBatchMaterial($row['product_mat_id'],$request_data['id']);
            $avilble_qty=$this->Stock_Counter_Model->get_stock_balance($row['psnm_warehouse_id'],$row['product_mat_id']);    
                
	        $nestad_data=array();
	        $nestad_data[]  = $row['product_mat_code'];
	        $nestad_data[]  = $row['product_mat_name'];
	        $nestad_data[]  = $row['mpt_name'];
	        $nestad_data[]  = $row['unit_name'];
	        $nestad_data[]  = $required_qty;  
	        $nestad_data[]  = $avilble_qty; 
	         $data[]=$nestad_data;
	    }
	     $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        }else{
            $output = array(
                'data' => array(),
                "recordsTotal" => intval(0),
                "recordsFiltered" => intval(0)
            );
            echo json_encode($output);
        }
   }
   
   function updteStoreNote(){
        $this->load->library('form_validation');
		$this->form_validation->set_rules('stn_master_id', 'Recode', 'required|xss_clean');
		$stn_master_id=$this->cleanAndValidateNumber($this->input->post('stn_master_id'));
		 if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'psnm_status'=>1,
			'finish_by'=>$this->session->userdata('ss_user_id'),
			'finish_on'=>date('Y-m-d H:i:s'),
		);
		$last_id= $this->executeUpdateMasterTable($stn_master_id,$data);
		$st = array('status' =>1,'validation' =>'Added','result'=>$last_id);
        echo json_encode($st);
		}
    }
    
    
    
    
  
  
  
  
  
   
}