<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports_Marketing extends CI_Controller {

    var $main_menu_name = "reports_marketing";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();

		
		$this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Transfer_Model');
		$this->load->model('Sales_Model');
		$this->load->model('Purchases_Model');
		$this->load->model('Report_Model');
		$this->load->model('Product_Damage_Model');
		$this->load->model('Sales_Return_Model');
		$this->load->model('Sequerty_Model');
		$this->load->model('Product_Models');
		$this->load->model('Customer_Model');
		$this->load->model('Expenses_Model');
		$this->load->model('User_Model');
		$this->load->model('Reports_Marketing_Model');
		
	}
	
	public function daily_cash_note()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'daily_cash_note';
		$data['cash_collector_list'] = $this->Reports_Marketing_Model->get_active_cash_collector();
		$this->load->view('marketing_reports/rep_deaily_cash_note',$data);
	}	
	
	
	/*sale report rep wise start*/
	public function sales_note_report()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'sales_note_report';
		$data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
		$this->load->view('rep_sales_note_report',$data);
	}
	
	
	public function daily_delivery_summary()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'daily_delivery_summary';
		$data['delivery_list'] = $this->Reports_Marketing_Model->get_active_delivery();
		$this->load->view('marketing_reports/delivery_summary',$data);
	}	
	
	
	
	public function get_delivery_sale_list_by_date()
	{
		$deliver_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		//$to_date=$this->input->get('to_date');
		
		$invoice_product_list=$this->Reports_Marketing_Model->get_invoice_list_product($deliver_id,$from_date);
		$json_data=array();
		
		foreach($invoice_product_list as $row)
		{
		 $nested_data=array();
		 
		  $sold_qty_and_value=$this->Reports_Marketing_Model->get_sold_qty_and_sub_total($row['product_id'],$deliver_id,$from_date);
		
		 $nested_data[]=$row['product_code'];
		 $nested_data[]=$row['product_name'];
		 $nested_data[]=$sold_qty_and_value['quantity'];		
		 $nested_data[]=$sold_qty_and_value['gross_total'];
		
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}	
	
	
	public function get_delivery_return_list_by_date()
	{
		$deliver_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		//$to_date=$this->input->get('to_date');
		
		$return_product_list=$this->Reports_Marketing_Model->get_return_list_product($deliver_id,$from_date);
		$json_data=array();
		
		foreach($return_product_list as $row)
		{
		 $nested_data=array();
		 $nested_data[]=$row['product_code'];
		 $nested_data[]=$row['product_name'];
		 $nested_data[]=$row['return_qty'];		
		 $nested_data[]=$row['return_date_time'];
		
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}	
	
	
	
	
	
	//----------------------------------------------------------------------------------
	
	
	
	
	
	
	
	
	
	public function get_sales_note_report_rep_id_and_date()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		$invoice_item_list=$this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date($sale_rep_id,$from_date,$to_date);
		
		$json_data=array();
		
		foreach($invoice_item_list as $row)
		{
		 $nested_data=array();
		 
		 
		 
		
		 
		
		$date=date_create($row['sale_datetime']);
		$converted_date=date_format($date,"Y-m-d");		 
		
		 $nested_data[]=$row['product_code'];
		 $nested_data[]=$row['product_name'];
		 $nested_data[]=0;
		 $nested_data[]=0;
		
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}	
	
	
	public function get_sales_note_report_rep_id_and_date_invoice_wise()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		$invoice_item_list2=$this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date_invoice_wise($sale_rep_id,$from_date,$to_date);
		
		$json_data=array();
		
		foreach($invoice_item_list2 as $row)
		{
		 $nested_data=array();
		 
		 
		 
		 if(isset($row['sale_total'])and isset($row['sale_pymnt_amount']))
		 {
			 $to_be_paid=$row['sale_total']-$row['sale_pymnt_amount']; 
		 }
		 else
		 {
			$to_be_paid=0; 
		 }
		 if($to_be_paid==0)
		 {
		 $lable='<span class="label label-warning">Pending</span>';
		 }
		 else
		 {
			if($to_be_paid>0) 
			{
			$lable='<span class="label label-info">Partial</span>';	
			}
			 
		 }
		
		 $date=date_create($row['sale_datetime']);
		$converted_date=date_format($date,"Y-m-d");
		 
		  $nested_data[]=$converted_date;
		 $nested_data[]=$row['card_ref_number']." / " .$row['sale_reference_no'];
		$nested_data[]=$row['cus_name'];
		 $nested_data[]=$row['sale_total'];
		 $nested_data[]=$row['totat_down_payment'];
		 $nested_data[]=$row['sale_pymnt_amount'];
		 $nested_data[]=$to_be_paid;
		 $nested_data[]=$row['sale_pymnt_paying_by'];
		 $nested_data[]=$lable;
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}
	
	public function get_sale_by_rep_id_and_date_summary()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		
		$invoice_item_list3=$this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary($sale_rep_id,$from_date,$to_date );	
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}
	
	public function get_sale_by_rep_id_and_date_summary_cash()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cash($sale_rep_id,$from_date,$to_date);		
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}	
	
	public function get_sale_by_rep_id_and_date_summary_cheque()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cheque($sale_rep_id,$from_date,$to_date);		
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}	
	
	public function get_sale_by_rep_id_and_date_summary_total()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$from_date=$this->input->get('from_date');
		$to_date=$this->input->get('to_date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_total($sale_rep_id,$from_date,$to_date);		
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}	
	
	
	
	/*sale report rep wise end*/
	
	public function daily_sales_note()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = 'daily_sales_note';
		$data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
		$this->load->view('marketing_reports/rep_deaily_sales_note',$data);
	}	
	
	
	public function get_daily_sale_by_rep_id_and_date_summary_print()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$summary=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id,$date);		
		$cash_value=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id,$date);
		$cheque=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id,$date);
		$invoice_item_list=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id,$date);
		$data['sales_list']= $invoice_item_list;
		$data['summary']= $summary;
		$data['cash_value']= $cash_value;
		$data['cheque']= $cheque;
		$this->load->view('models/print_daily_rep_summary',$data);
	}	
	
	
	
	public function get_daily_cash_by_collector_id_and_date_summary_print()
	{
		$collector_id=$this->input->get('collector_id');
		$date=$this->input->get('date');
		$summary=$this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id,$date);
		
		
		$cash_item_list=$this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id,$date);
		
		
		$data['cash_list']= $cash_item_list;
		$data['summary']= $summary;
		
		//print_r($cash_item_list );
		
		$this->load->view('models/print_daily_cash_collector_summary',$data);
	}	
	
	public function get_daily_cash_by_collector_and_date_summary()
	{
		$collector_id=$this->input->get('collector_id');
		$date=$this->input->get('date');
		$collected_cash2=$this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id,$date);
		//print_r($collected_cash2);
		
		
		$json_data=array();
		$json_data=$collected_cash2;
		echo json_encode(array('data'=>$json_data));
		
	}
	
	
	public function get_daily_sale_by_rep_id_and_date_summary()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id,$date);
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));		
	}
public function get_daily_sale_by_rep_id_and_date_summary_cash()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id,$date);
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}	
	
	public function get_daily_sale_by_rep_id_and_date_summary_cheque()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$invoice_item_list3=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id,$date);
		//print_r($invoice_item_list3);
		
		
		$json_data=array();
		$json_data=$invoice_item_list3;
		echo json_encode(array('data'=>$json_data));
		
	}	
	
	
	
	
	public function get_daily_sale_by_rep_id_and_date_final()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$invoice_item_list2=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_final($sale_rep_id,$date);
		
		$json_data=array();
		
		foreach($invoice_item_list2 as $row)
		{
		 $nested_data=array();	
		
			
		 
		 if(isset($row['sale_pymnt_amount']))
		 {
			 $to_be_paid=$row['sale_total']-$row['sale_pymnt_amount']; 
		 }
		 else
		 {
			$to_be_paid=$row['sale_total']; 
		 }
		
		
		 
		 
		 $nested_data[]=$row['card_ref_number']." / " .$row['sale_reference_no'];
		 $nested_data[]=$row['cus_name'];
		 $nested_data[]=$row['sale_total'];
		 $nested_data[]=$row['sale_pymnt_amount'];
		 $nested_data[]=$to_be_paid;
		 $nested_data[]=$row['sale_pymnt_paying_by'];
		
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}
	
	
	
	
	public function get_daily_sale_by_rep_id_and_date()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');		
		$invoice_item_list=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id,$date);		
		$json_data=array();
		
		foreach($invoice_item_list as $row)
		{
		 $nested_data=array();
		
		 
		 
		 $nested_data[]=$row['card_ref_number']." / " .$row['sale_reference_no'];
		 $nested_data[]=$row['product_name'];
		 $nested_data[]=$row['quantity'];
		 $nested_data[]=$row['gross_total'];
		
		 $nested_data[]=$row['cus_name']." (".$row['cus_code'].")";
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}
	
	function get_daily_sale_by_rep_id_and_date_sales_note_report()
	{
		$sale_rep_id=$this->input->get('rep_id');
		$date=$this->input->get('date');
		$to_date=$this->input->get('to_date');
		
		$invoice_item_list=$this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_sales_note_report($sale_rep_id,$date,$to_date);
		//print_r($invoice_item_list);
		
		$json_data=array();
		
		foreach($invoice_item_list as $row)
		{
		 $nested_data=array();
		 
		 
		 
		 if(isset($row['gross_total'])and isset($row['sale_pymnt_amount']))
		 {
			 $to_be_paid=$row['gross_total']-$row['sale_pymnt_amount']; 
		 }
		 else
		 {
			$to_be_paid=0; 
		 }
		 if($to_be_paid==0)
		 {
		 $lable='<span class="label label-warning">Pending</span>';
		 }
		 else
		 {
			if($to_be_paid>0) 
			{
			$lable='<span class="label label-info">Partial</span>';	
			}
			 
		 }
		
		 //print_r($row);
		 $nested_data[]=$row['sale_datetime'];
		 $nested_data[]=$row['card_ref_number']." / " .$row['sale_reference_no'];
		 $nested_data[]=$row['product_name'];
		 $nested_data[]=$row['quantity'];
		 $nested_data[]=$row['gross_total'];
		 //$nested_data[]=$row['totat_down_payment'];
		 //$nested_data[]=$row['sale_pymnt_amount'];
		 //$nested_data[]=$row['sale_pymnt_paying_by'];
		 // $nested_data[]=$to_be_paid;
		 $nested_data[]=$lable;
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}
	
	public function get_daily_cash_by_collector_id_and_date()
	{
		$collector_id=$this->input->get('collector_id');
		$date=$this->input->get('date');
		
		
		$cash_list=$this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id,$date);
		//print_r($cash_list);
		
		$json_data=array();
		
		foreach($cash_list as $row)
		{
		 $nested_data=array();
		 
		 
		 
		
		 
		 
		 $nested_data[]=$row['card_ref_number']." / " .$row['sale_reference_no'];
		
		 $nested_data[]=$row['sale_pymnt_amount'];
		
		
		
		 
		 $json_data[]=$nested_data;
			
		}
		
		echo json_encode(array('data'=>$json_data));
	}
}