<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Purchases_Return_Models extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    function get_purchase_master_details($id){
        $this->db->select('p.*,s.supp_company_name,s.supp_code,w.code,w.name');
        $this->db->from('purchases p');
        $this->db->join('supplier s', 's.supp_id = p.supplier_id', 'left');
        $this->db->join('warehouses w', 'w.id = p.warehouse_id', 'left');
        $this->db->where("p.id",$id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
     function get_purchase_item_details($term='',$id=''){
        $this->db->select('pi.*,s.product_mat_code,s.product_mat_name,s.product_mat_part_no,s.product_mat_oem_part_number,b.batch_ref_number,b.batch_id,p.date');
        $this->db->from('purchase_items pi');
        $this->db->join('purchases p', 'p.id = pi.purchase_id', 'inner');
        $this->db->join('product_material s', 's.product_mat_id = pi.product_id', 'inner');
        $this->db->join('btatch_prroduct_grn bg', 'bg.grn_item_id = pi.id', 'inner');
        $this->db->join('batch_product b', 'b.batch_id = bg.batch_id', 'inner');
        $this->db->where("pi.purchase_id",$id);
        $this->db->where("(s.product_mat_name LIKE '%$term%' OR s.product_mat_code LIKE '%$term%' OR b.batch_ref_number LIKE '%$term%')");
        //$this->db->where("s.product_name LIKE '%$term%'");
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function save_purchase_return($pd)
    {
        if ($this->db->insert('purchase_return', $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    function save_purchase_return_item($pd)
    {
        if ($this->db->insert('purchase_return_items', $pd)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    function get_purchase_return_master_details($id){
        $this->db->select('p.*,s.supp_company_name,s.supp_code,w.code,w.name,g.reference_no,w.address,w.phone,w.email,s.supp_address,s.supp_company_phone,s.supp_email,u.user_first_name');
        $this->db->from('purchase_return p');
        $this->db->join('supplier s', 's.supp_id = p.supplier_id', 'left');
        $this->db->join('warehouses w', 'w.id = p.warehouse_id', 'left');
        $this->db->join('purchases g', 'g.id = p.grn_id', 'left');
        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        $this->db->where("p.pur_return_id",$id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    function get_purchase_master_list(){
        $this->db->select('p.*,s.supp_company_name,s.supp_code,w.code,w.name,w.address,w.phone,w.email');
        $this->db->from('purchase_return p');
        $this->db->join('supplier s', 's.supp_id = p.supplier_id', 'left');
        $this->db->join('warehouses w', 'w.id = p.warehouse_id', 'left');
        //$this->db->where("p.id",$id);
        $query = $this->db->get();
        return $query->result();
    }
    
     function get_purchase_return_item_list($id){
        $this->db->select('pi.*,s.product_code,s.product_name,s.product_part_no,s.product_oem_part_number,b.batch_ref_number,b.batch_id');
        $this->db->from('purchase_return_items pi');
        $this->db->join('product s', 's.product_id = pi.product_id', 'left');
        $this->db->join('batch_product b', 'b.batch_id = pi.batch_id', 'left');
        $this->db->where("pi.pur_r_item_id",$id);
        $query = $this->db->get();
        return $query->result_array();
    }
    
     function getProducts($start, $length, $search_key_val)
    {
        $this->db->select('b.batch_ref_number,b.batch_id,b.retail_cash');
        $this->db->select('pi.*');
        $this->db->select('w.name');
        $this->db->select('pm.reference_no,pm.date,pm.id AS grn_master_id');
        $this->db->select('p.product_mat_code,p.product_mat_name');
        $this->db->from('purchase_items pi');
        $this->db->join('btatch_prroduct_grn bg', 'bg.grn_item_id = pi.id', 'inner');
        $this->db->join('purchases pm', 'pm.id = pi.purchase_id', 'inner');
        $this->db->join('warehouses w', 'w.id = pm.warehouse_id', 'inner');
        $this->db->join('batch_product b', 'b.batch_id = bg.batch_id', 'inner');
        $this->db->join('product_material p', 'p.product_mat_id = pi.product_id', 'inner');
    
        if ($search_key_val) {
            $this->db->where("p.product_mat_code = '$search_key_val' OR p.product_mat_name LIKE '%$search_key_val%' OR  b.batch_ref_number = '$search_key_val' ");
           
        }
		$this->db->order_by("pi.id", "desc");
		//$this->db->group_by("pi.id");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    
    
    
    
    
  
}