<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Sample_Process_Model extends CI_Model {

  

  private $master_tableName = 'sample_order_master';
  private $master_primary_key = 'sample_master_id';
  
  private $item_tableName = 'sample_order_items';
  private $item_primary_key = 'sample_order_item_id';
  

  function __construct() 

  {
	 /* Call the Model constructor */
    parent::__construct();
  }

  

	

	public function get_product_suggestion($term)

	{
		$this->db->select('product'.'.*');
		$this->db->order_by("product_name", "asc");
		$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");
		 $this->db->limit(10, 0);
		 $query = $this->db->get('product');
		 return $query->result_array();
	}

	
 function insert_update_master_table($data,$id)
	{
	if ($id==0)
	{
		$this->db->insert($this->master_tableName,$data);	
	}else
	{
		$this->db->where($master_primary_key,$id);
		return $this->db->update($this->master_tableName,$data);
	}
	}
	
	 function insert_update_item_table($data,$id)
	{
		if ($id=='')
		{
		return $this->db->insert($this->item_tableName,$data);	
		}else
		{
		$this->db->where($item_primary_key,$id);
		return $this->db->update($this->item_tableName,$data);
		}
	}		
	
	
	
	 public function get_sample_order_master_details($order_id)
  {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id='.$this->master_tableName.'.route_id','left');
	  $this->db->where($this->master_tableName.'.sample_master_id',$order_id);
	  $query=$this->db->get();
	  return $query->row_array();	
  }
  
  function get_sample_order_item_details($order_id)
	{
		$this->db->select('so.product_id,so.add_sales_excess_price,so.add_sales_discount_price, so.product_price,so.product_cost, so.order_qty,so.after_discount_added_price,so.total_price,so.total_cost');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number');
		$this->db->from('sample_order_items so');
		$this->db->join('product p','so.product_id = p.product_id','left');
		$this->db->where('so.sample_order_master_id',$order_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	 public function get_sample_order_master_list()
  {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id='.$this->master_tableName.'.route_id','left');
	  $this->db->where($this->master_tableName.'.status',1);
	  $query=$this->db->get();
	  return $query->result_array();	
  }





}