<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Supplier_Payment_Process_Model extends CI_Model
{
    private $tableName = 'sale_multiple_payment';
    function __construct()
    {
        parent::__construct();
        // $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
     public function get_grn_complete_info_by_customer_id($id)
    {
        $this->db->select('p.*');
        $this->db->from('purchases p');
        $this->db->where("p.supplier_id", $id);
        $this->db->where("p.payment_status", 0);
        $this->db->where("p.approval_status",1);
        $this->db->order_by("p.date", "asc");
        $this->db->limit(1000);
        $query = $this->db->get();
        // SELECT `p`.* FROM (`purchases` p) WHERE `p`.`supplier_id` = '2' AND `p`.`payment_status` = 0 AND `p`.`approval_status` = 1 ORDER BY `p`.`date` asc LIMIT 200

        //echo $this->db->last_query();
        return $query->result();
    }
     public function get_grn_total_payment($id)
    {
        $this->db->select_sum('p.allocation_amount');
        $this->db->from('payment_given_items p');
        $this->db->where("p.invoice_id", $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['allocation_amount'])){
            return $result['allocation_amount'];
        }else{
            return 0;
        }
    }
     public function get_grn_return_total_payment($id)
    {
        $this->db->select_sum('p.total_net_amount');
        $this->db->from('purchase_return p');
        $this->db->where("p.grn_id", $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['total_net_amount'])){
            return $result['total_net_amount'];
        }else{
            return 0;
        }
    }
    function save_grn_multiple_payment_header(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('payment_given_master', $supplier_data);
            return $this->db->insert_id();
        } else {
            $this->db->where('pay_g_id', $exp_id);
            $this->db->update($this->tableName, $supplier_data);
            return $exp_id;
        }
    }
    function save_grn_multiple_payment_items(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('payment_given_items', $supplier_data);
            return $this->db->insert_id();
        } else {
            $this->db->where('pay_g_i_id', $exp_id);
            $this->db->update($this->tableName, $supplier_data);
            return $exp_id;
        }
    }
    
    function get_all_suplier_payment($start,$length,$search) {
		$this->db->select('p.*, s.*,mt.p_type_name,b.bank_name');
		$this->db->from('payment_given_master p');
		$this->db->join('supplier s', 'p.account_id = s.supp_id', 'inner');	
		$this->db->join('mstr_payment_type mt', 'p.payment_type = mt.p_type_id', 'inner');	
		$this->db->join('mstr_bank b', 'p.bank_id = b.bank_id', 'left');
		
		if(isset($search['value']))
		if($search['value']){		
				$this->db->like('s.supp_company_name', $search['value']);
				$this->db->or_like('p.payment_system_ref_no', $search['value']);
				$this->db->or_like('p.ref_no', $search['value']);
			}
		if($start!='' && $length!=''){
            $this->db->limit($length,$start);
			}
		$this->db->order_by("p.system_date_time", "desc");		
		if($start!='' && $length!=''){
			$query=$this->db->get();
			return $query->result();            
		}else{
			$query = $this->db->get();
			return $query->num_rows();
		}
	}
	function get_suplier_payment_details_by_id($id) {
		$this->db->select('p.*, s.*,mt.p_type_name,b.bank_name,ba.account_no');
		$this->db->from('payment_given_master p');
		$this->db->join('supplier s', 'p.account_id = s.supp_id', 'inner');	
		$this->db->join('mstr_payment_type mt', 'p.payment_type = mt.p_type_id', 'inner');	
		$this->db->join('mstr_bank_account ba', 'p.bank_id = ba.mba_id', 'left');
		$this->db->join('mstr_bank b', 'ba.bank_id = b.bank_id', 'left');
		$this->db->where("p.pay_g_id", $id);
		$query=$this->db->get();
		return $query->row_array(); 
	}
	
	function get_suplier_payment_item_list_by_id($id) {
		$this->db->select('p.*,pr.*');
		$this->db->from('payment_given_items p');
		$this->db->join('purchases pr', 'pr.id = p.invoice_id', 'inner');
		//$this->db->join('payment_given_master pm', 'mp.pay_g_id = p.pgm_id', 'inner');
		//$this->db->join('supplier s', 'p.account_id = s.supp_id', 'inner');	
		//$this->db->join('mstr_payment_type mt', 'p.payment_type = mt.p_type_id', 'inner');	
		//$this->db->join('mstr_bank b', 'p.bank_id = b.bank_id', 'left');
		$this->db->where("p.pgm_id", $id);
		$query=$this->db->get();
		return $query->result();            
		
	}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    function get_all_list_sale_multiple_payment()
    {
        $this->db->select('mp.*,c.*,ps.p_status_name,pt.p_type_name,b.bank_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id','left');
        $this->db->join('mstr_payment_type pt', 'pt.p_type_id = mp.payment_type','left');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = mp.payment_status','left');
        $this->db->join('mstr_bank b', 'b.bank_id = mp.bank_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_sale_multiple_payment_details_by_id($smp_id)
    {
        $this->db->select('mp.*,c.cus_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id');
        $this->db->where("mp.smp_id", $smp_id);
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->row();
    }
    public function get_sale_multiple_payment_items_by_id($smp_id)
    {
        $this->db->select('p.*, s.*');
        $this->db->from('sale_payments p');
        $this->db->join('sales s', 's.sale_id = p.sale_id', 'left');
        $this->db->where("p.smp_id", $smp_id);
		$this->db->where("p.sale_payment_type", 'sale');
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
	public function delete_sale_multiple_payment_by_id($smp_id)
    {
		if($this->db->query('DELETE FROM sale_payments WHERE smp_id = '.$smp_id.' AND sale_payment_type=\'sale\''))
		if($this->db->query('DELETE FROM sale_multiple_payment WHERE smp_id = '.$smp_id))
			return 1;
    }
    function get_next_ref_no()
    {
        $this->db->select_max('smp_last_id');
        $query = $this->db->get('sale_multiple_payment');
        return $query->row();
    }
    function save_sale_multiple_payment_header(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('sale_multiple_payment', $supplier_data);
            return $smp_id;
        } else {
            $this->db->where('smp_id', $exp_id);
            return $this->db->update($this->tableName, $supplier_data);
        }
    }
   
    function save_sale_multiple_payment(&$data_item)
    {
        if ($this->db->insert('sale_payments', $data_item)) {
            return true;
        } else {
            return false;
        }
    }


    function update_cheque($id='',$data)
    {
        if ($id) {
            $this->db->where('smp_id', $id);
            return $this->db->update($this->tableName, $data);
           
        } else {
           return false;
        }
    }


    function get_all_recode()
    {
        $this->db->select('mp.*,c.sale_pymnt_paying_by,c.sale_pymnt_cheque_no,c.sale_pymnt_date_time');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('sale_payments c', 'c.smp_id = mp.smp_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
    
     function get_grn_payment_balance($id){
        $sale_paid_amount = $this->get_grn_total_payment($id);
        $grn_return_total = 0;//$this->get_grn_return_total_payment($id);
        return round($sale_paid_amount+$grn_return_total, 2) ;
    }
    	 public function get_pending_grn_supplier()
    {
        $this->db->select('p.supplier_id');
        $this->db->from('purchases p');
        $this->db->where("p.payment_status", 0);
        $this->db->order_by("p.id", "asc");
        $this->db->group_by('p.supplier_id');
        $this->db->limit(200);
        $query = $this->db->get();
        return $query->result_array();
    }
      function update_purcheses_table($id,$data)
    {
        if ($id) {
            $this->db->where('id', $id);
            return $this->db->update('purchases', $data);
           
        } else {
           return false;
        }
    }
    
   





}